<div class="mf-admin-card mf-admin-card-shadow">
    <img src="<?php echo self::get_url() . 'assets/images/banner_dashboard.png'; ?>" class="mf-admin-dashboard-banner" />
</div>

<!-- Documentation -->
<div class="mf-admin-section mf-admin-dual-layout mf-admin-documentation-section">
    <div class="mf-admin-left-thumb">
        <img src="<?php echo self::get_url() . 'assets/images/documentation-thumb.png'; ?>" alt="<?php esc_attr_e('Documentation Thumb', 'metform'); ?>">
    </div>
    <div class="mf-admin-right-content">
        <div class="mf-admin-right-content--heading">
            <h2><?php esc_html_e('Easy Documentation', 'metform') ?></h2>
            <span class="mf-admin-right-content--heading__sub-title"><?php esc_html_e('Docs', 'metform') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'metform'); ?></p>
        <div class="mf-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/elementskit-docs" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-newspaper-o"></i><?php esc_html_e('Get started', 'metform'); ?></a>
        </div>
    </div>
</div>

<!-- Video tutorials -->
<div class="mf-admin-section mf-admin-faq-section">
    <div class="mf-admin-right-content attr-text-center">
        <div class="mf-admin-right-content--heading">
            <h2><?php esc_html_e('Video Tutorials', 'metform') ?></h2>
            <span class="mf-admin-right-content--heading__sub-title"><?php esc_html_e('Tutorials', 'metform') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'metform'); ?></p>
    </div>

    <div class="mf-admin-video-tutorial-list">
        <div class="mf-admin-video-tutorial-item">
            <a target="_blank" href="https://wpmet.com/plugin/elementskit/parallax-landing/">
                <div class="tutorial-thumb">
                    <img src="<?php echo self::get_url() . 'assets/images/suport-thumb.png'; ?>" alt="<?php esc_attr_e('Totorial Thumb', 'metform'); ?>">
                </div>
                <h2><?php esc_html_e('Parallax Effects', 'metform'); ?></h2>
            </a>
        </div>
        <div class="mf-admin-video-tutorial-item">
            <a href="#" data-video_id="oV-7-NNiGZo">
                <div class="tutorial-thumb">
                    <img src="<?php echo self::get_url() . 'assets/images/subscribed-thumb.png'; ?>" alt="<?php esc_attr_e('Totorial Thumb', 'metform'); ?>">
                </div>
                <h2><?php esc_html_e('Advanced Accordions', 'metform'); ?></h2>
            </a>
        </div>
        <div class="mf-admin-video-tutorial-item">
            <a href="#" data-video_id="LfFN08Y9VQE">
                <div class="tutorial-thumb">
                    <img src="<?php echo self::get_url() . 'assets/images/featured-request-thumb.png'; ?>" alt="<?php esc_attr_e('Totorial Thumb', 'metform'); ?>">
                </div>
                <h2><?php esc_html_e('Mega Menu Builder', 'metform'); ?></h2>
            </a>
        </div>
    </div>
    <div class="mf-admin-video-tutorial-popup">
        <div class="mf-admin-video-tutorial-popup-content">
            <div class="mf-admin-video-tutorial-iframe"></div>
            <div class="mf-admin-video-tutorial-close"><i class="fa fa-times"></i></div>
        </div>
    </div>

    
    <div class="mf-admin-right-content--button attr-text-center">
        <a target="_blank" href="https://www.youtube.com/watch?v=ps7knxZpDFI&list=PL3t2OjZ6gY8MVnyA4OLB6qXb77-roJOuY" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e('watch more videos', 'metform'); ?></a>
    </div>
</div>

<!-- FAQ -->
<div class="mf-admin-section mf-admin-faq-section" style="display: none">
    <div class="mf-admin-right-content attr-text-center">
        <div class="mf-admin-right-content--heading">
            <h2><?php esc_html_e('General Knowledge Base', 'metform') ?></h2>
            <span class="mf-admin-right-content--heading__sub-title"><?php esc_html_e('FAQ', 'metform') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'metform'); ?></p>
    </div>

    <div class="mf-admin-accordion">
        <div class="mf-admin-single-accordion">
            <h2 class="mf-admin-single-accordion--heading"><?php esc_html_e('1. How to create a shop page in ElementsKit Lite?', 'metform'); ?></h2>
            <div class="mf-admin-single-accordion--body">
                <div class="mf-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'metform'); ?></p>
                </div>
            </div>
        </div>
        <div class="mf-admin-single-accordion">
            <h2 class="mf-admin-single-accordion--heading"><?php esc_html_e('2. How to translate theme with WPML?', 'metform'); ?></h2>
            <div class="mf-admin-single-accordion--body">
                <div class="mf-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'metform'); ?></p>
                </div>
            </div>
        </div>
        <div class="mf-admin-single-accordion">
            <h2 class="mf-admin-single-accordion--heading"><?php esc_html_e('3. How to add custom css in specific section shortcode?', 'metform'); ?></h2>
            <div class="mf-admin-single-accordion--body">
                <div class="mf-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'metform'); ?></p>
                </div>
            </div>
        </div>
    </div>

    
    <div class="mf-admin-right-content--button attr-text-center">
        <a target="_blank" href="https://www.youtube.com/channel/UCpsjAqTeTqwFTMV580D3YvQ" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e('View all faq’s', 'metform'); ?></a>
    </div>
</div>

<!-- Support -->
<div class="mf-admin-section mf-admin-dual-layout mf-admin-support-section">
<div class="mf-admin-right-content">
        <div class="mf-admin-right-content--heading">
            <h2><?php esc_html_e('Top-notch Friendly Support', 'metform') ?></h2>
            <span class="mf-admin-right-content--heading__sub-title"><?php esc_html_e('Support', 'metform') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'metform'); ?></p>
        <div class="mf-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/support-ticket" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e('Join support forum', 'metform'); ?></a>
        </div>
    </div>
    
    <div class="mf-admin-left-thumb">
        <img src="<?php echo self::get_url() . 'assets/images/suport-thumb.png'; ?>" alt="<?php esc_attr_e('Documentation Thumb', 'metform'); ?>">
    </div>
    
</div>

<!-- Feature a Request -->
<div class="mf-admin-section mf-admin-dual-layout mf-admin-feature-request-section mf-admin-except-title">
    <div class="mf-admin-left-thumb">
        <img src="<?php echo self::get_url() . 'assets/images/featured-request-thumb.png'; ?>" alt="<?php esc_attr_e('Feature a Request Thumb', 'metform'); ?>">
    </div>
    <div class="mf-admin-right-content">

        <p><?php esc_html_e('Maybe we’re missing something you can’t live without.', 'metform'); ?></p>
        <div class="mf-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/feature-request" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e('Feature a request', 'metform'); ?></a>
        </div>
    </div>
</div>

<!-- Rate Now -->
<div class="mf-admin-section mf-admin-dual-layout mf-admin-rate-now-section mf-admin-except-title">
    
    <div class="mf-admin-right-content">

        <p><span><?php esc_html_e('Satisfied?', 'metform'); ?></span><?php esc_html_e('Don’t forget to rate our item.', 'metform'); ?></p>
        <div class="mf-admin-right-content--button">
            <a target="_blank" href="https://wordpress.org/support/plugin/metform/reviews/?rate=5#new-post" class="attr-btn attr-btn-primary mf-admin-right-content--link"><i class="fa fa-star"></i><?php esc_html_e('Rate it now', 'metform'); ?></a>
        </div>
    </div>

    <div class="mf-admin-left-thumb">
        <img src="<?php echo self::get_url() . 'assets/images/rate-now-thumb.png'; ?>" alt="<?php esc_attr_e('Rate Now Thumb', 'metform'); ?>">
    </div>
</div>